/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config.ui;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.RangeConstraint;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.component.ConfigEnumButton;
import io.wispforest.owo.config.ui.component.ConfigSlider;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.config.ui.component.ConfigToggleButton;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.parsing.UIModel;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class OptionComponents {
    public static OptionComponentFactory.Result createTextBox(UIModel model, Option<?> option, Consumer<ConfigTextBox> processor) {
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "text-box-config-option", OptionComponents.packParameters(option.translationKey(), option.value().toString()));
        ConfigTextBox valueBox = optionComponent.childById(ConfigTextBox.class, "value-box");
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        if (option.detached()) {
            resetButton.field_22763 = false;
            valueBox.method_1888(false);
        } else {
            resetButton.field_22763 = !valueBox.method_1882().equals(option.defaultValue().toString());
            resetButton.onPress(button -> {
                valueBox.method_1852(option.defaultValue().toString());
                button.field_22763 = false;
            });
            valueBox.onChanged().subscribe(s -> {
                resetButton.field_22763 = !s.equals(option.defaultValue().toString());
            });
        }
        processor.accept(valueBox);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString();
        supplierArray[1] = () -> ((ConfigTextBox)valueBox).method_1882();
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), supplierArray));
        return new OptionComponentFactory.Result(optionComponent, valueBox);
    }

    public static OptionComponentFactory.Result createSlider(UIModel model, Option<? extends Number> option, boolean withDecimals) {
        Number value = option.value();
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "range-config-option", OptionComponents.packParameters(option.translationKey(), value.toString()));
        RangeConstraint constraint = option.backingField().field().getAnnotation(RangeConstraint.class);
        double min = constraint.min();
        double max = constraint.max();
        ConfigSlider valueSlider = optionComponent.childById(ConfigSlider.class, "value-slider");
        valueSlider.min(min).max(max).decimalPlaces(withDecimals ? 2 : 0).snap(!withDecimals).setFromDiscreteValue(value.doubleValue());
        valueSlider.valueType(option.clazz());
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        if (option.detached()) {
            resetButton.field_22763 = false;
            valueSlider.field_22763 = false;
        } else {
            resetButton.field_22763 = (withDecimals ? value.doubleValue() : (double)Math.round(value.doubleValue())) != option.defaultValue().doubleValue();
            resetButton.onPress(button -> {
                valueSlider.setFromDiscreteValue(((Number)option.defaultValue()).doubleValue());
                button.field_22763 = false;
            });
            valueSlider.onChanged().subscribe(newValue -> {
                resetButton.field_22763 = (withDecimals ? newValue : (double)Math.round(newValue)) != ((Number)option.defaultValue()).doubleValue();
            });
        }
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString(), () -> valueSlider.method_25369().getString()));
        return new OptionComponentFactory.Result(optionComponent, valueSlider);
    }

    public static OptionComponentFactory.Result createToggleButton(UIModel model, Option<Boolean> option) {
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "boolean-toggle-config-option", OptionComponents.packParameters(option.translationKey(), option.value().toString()));
        ConfigToggleButton toggleButton = optionComponent.childById(ConfigToggleButton.class, "toggle-button");
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        toggleButton.enabled(option.value());
        if (option.detached()) {
            resetButton.field_22763 = false;
            toggleButton.field_22763 = false;
        } else {
            resetButton.field_22763 = option.value() != option.defaultValue();
            resetButton.onPress(button -> {
                toggleButton.enabled((Boolean)option.defaultValue());
                button.field_22763 = false;
            });
            toggleButton.onPress(button -> {
                resetButton.field_22763 = toggleButton.parsedValue() != option.defaultValue();
            });
        }
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString(), () -> toggleButton.method_25369().getString()));
        return new OptionComponentFactory.Result(optionComponent, toggleButton);
    }

    public static OptionComponentFactory.Result createEnumButton(UIModel model, Option<? extends Enum<?>> option) {
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "enum-config-option", OptionComponents.packParameters(option.translationKey(), option.value().toString()));
        ConfigEnumButton enumButton = optionComponent.childById(ConfigEnumButton.class, "enum-button");
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        enumButton.init(option, option.value().ordinal());
        if (option.detached()) {
            resetButton.field_22763 = false;
            enumButton.field_22763 = false;
        } else {
            resetButton.field_22763 = option.value() != option.defaultValue();
            resetButton.onPress(button -> {
                enumButton.select(((Enum)option.defaultValue()).ordinal());
                button.field_22763 = false;
            });
            enumButton.onPress(button -> {
                resetButton.field_22763 = enumButton.parsedValue() != option.defaultValue();
            });
        }
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString(), () -> enumButton.method_25369().getString()));
        return new OptionComponentFactory.Result(optionComponent, enumButton);
    }

    public static Map<String, String> packParameters(String name, String value) {
        return Map.of("config-option-name", name, "config-option-value", value);
    }
}

